# Eternal Auto Blogger - Free

🤖 An autonomous AI-powered content engine that researches, plans, writes, and publishes SEO-optimized article clusters based on persona-driven thought spheres.

**Free Version** - Powered by OpenAI GPT-4 & DALL-E

**Developed by [Ventus Media](https://www.ventusserver.com)**

## ✨ Features

- **🌐 Thought Spheres**: Creates clusters of 7 interconnected articles (1 pillar + 6 supporting)
- **👤 AI Personas**: Define unique author personalities with specific expertise, interests, and writing styles
- **🔍 Automated Research**: Discovers trending topics using Google Autocomplete, People Also Ask, DuckDuckGo, and more - FREE!
- **✍️ AI-Powered Writing**: Generates SEO-optimized content using GPT-4
- **🖼️ Image Generation**: Automatically creates featured images with DALL-E 3
- **🔗 Smart Internal Linking**: Automatically links articles within spheres
- **📊 RankMath Compatible**: SEO meta fields optimized for RankMath
- **♾️ Eternal Cycle**: Runs autonomously on cron schedule

## 🆓 Free Version Includes

- **OpenAI GPT-4** - Industry-leading AI writing
- **DALL-E 3** - Professional AI-generated images
- **Free Search** - 9 powerful data sources with no API costs:
  - Google Autocomplete (20+ modifiers)
  - DuckDuckGo related topics
  - Google PAA Scraper
  - Wikipedia Mining
  - Reddit Topics
  - Google Trends
  - And more!

## ⭐ Upgrade to Pro

Get additional features with the Pro version:
- Anthropic Claude (Sonnet 4 & Opus)
- Perplexity AI (High token limits)
- Custom Server support (Ollama)
- Stable Diffusion images
- Premium search APIs (Google CSE, SerpAPI, ValueSERP)
- Priority support
- Automatic updates

[Get Pro Version →](https://eternalautoblogger.com)

## 🚀 Installation

1. Upload the `ai-autoblogger` folder to `/wp-content/plugins/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to **Eternal Blogger > Settings** to configure your OpenAI API key
4. Create your first **Persona** under Eternal Blogger > Personas
5. Run manually or wait for the cron to trigger automatically!

## ⚙️ Configuration

### API Key Required

- **OpenAI API Key** - Get at [platform.openai.com](https://platform.openai.com)
  - Used for GPT-4 content generation and DALL-E 3 images

### Creating a Persona

Each persona represents an AI author with:
- **Name**: The persona's identity
- **Expertise Areas**: Topics they're knowledgeable about
- **Interests**: Related topics they find interesting
- **Passions**: What drives their writing
- **Voice Style**: Professional, casual, academic, etc.
- **Tone**: Informative, inspiring, practical, etc.
- **Target Audience**: Who they're writing for
- **Writing Guidelines**: Specific instructions for their content
- **Topics to Avoid**: Subjects they shouldn't cover

## 📝 How Thought Spheres Work

1. **Research Phase**: Discovers trending topics related to persona's expertise
2. **Planning Phase**: Selects pillar keyword and 6 supporting topics
3. **Writing Phase**: Generates pillar article (2500+ words) and cluster articles (1500+ words each)
4. **Linking Phase**: Injects internal links between all articles in the sphere
5. **Publishing Phase**: Publishes all 7 articles with SEO meta, featured images, and tags

### Internal Link Structure

```
        ┌──────────┐
        │  PILLAR  │
        └────┬─────┘
             │
    ┌────────┼────────┐
    │        │        │
┌───▼───┐┌───▼───┐┌───▼───┐
│Cluster││Cluster││Cluster│
│   1   ││   2   ││   3   │
└───┬───┘└───┬───┘└───┬───┘
    │        │        │
    └────────┼────────┘
             │
    ┌────────┼────────┐
    │        │        │
┌───▼───┐┌───▼───┐┌───▼───┐
│Cluster││Cluster││Cluster│
│   4   ││   5   ││   6   │
└───────┘└───────┘└───────┘
```

Each cluster links to:
- The pillar article
- Two other cluster articles (circular linking)

## 🔧 Troubleshooting

### Articles Not Generating?

1. Check your OpenAI API key is valid
2. Verify you have active personas with expertise areas defined
3. Check the Logs page for detailed error messages
4. Use "Clear Lock" on the dashboard if a process is stuck

### Images Not Appearing?

1. Ensure your OpenAI API key has DALL-E access
2. Check if image generation is enabled in Settings

## 📄 License

GPL v2 or later

## 🆘 Support

- Documentation: [eternalautoblogger.com](https://eternalautoblogger.com)
- Website: [ventusserver.com](https://www.ventusserver.com)
- Pro Support: [eternalautoblogger.com/support](https://eternalautoblogger.com/support)

---

**Version:** 2.6.0-free
