<?php
/**
 * Dashboard View
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap aiab-wrap">
    <h1>🤖 Eternal Auto Blogger - Free</h1>
    
    <?php 
    // Check for daily limit notification
    $daily_limit_data = get_transient('aiab_daily_limit_reached');
    if ($daily_limit_data && $daily_limit_data['date'] === date('Y-m-d')): 
    ?>
    <div class="aiab-limit-banner" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; margin-bottom: 20px; border-radius: 8px; display: flex; flex-wrap: wrap; align-items: center; gap: 20px;">
        <div style="flex: 1; min-width: 250px;">
            <h3 style="margin: 0 0 10px 0; color: white;">📊 Daily Sphere Limit Reached</h3>
            <p style="margin: 0; opacity: 0.95;">
                You've created <strong><?php echo $daily_limit_data['spheres']; ?> thought sphere(s)</strong> today. 
                The free version allows <strong>1 sphere per day</strong> (4 articles).
            </p>
            <p style="margin: 10px 0 0 0; font-size: 13px; opacity: 0.85;">
                🕐 Limit resets at midnight. Existing spheres will continue processing.
            </p>
        </div>
        <div>
            <a href="https://eternalautoblogger.com" target="_blank" class="button" style="background: white; color: #667eea; border: none; font-weight: bold; padding: 12px 25px; font-size: 14px; border-radius: 6px;">
                🚀 Upgrade to Pro - Unlimited Spheres
            </a>
        </div>
    </div>
    <?php endif; ?>
    
    <?php if (!empty($stats['needs_attention'])): ?>
    <div class="aiab-attention-banner" style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin-bottom: 20px; border-radius: 4px;">
        <h3 style="margin: 0 0 10px 0; color: #856404;">⚠️ Needs Attention</h3>
        <ul style="margin: 0; padding-left: 20px; color: #856404;">
            <?php if (!$stats['cron_enabled']): ?>
                <li><strong>Auto-Run Disabled!</strong> Go to Cron Scheduler below to enable automatic cycles.</li>
            <?php endif; ?>
            <?php if ($stats['stuck_articles'] > 0): ?>
                <li><strong><?php echo $stats['stuck_articles']; ?> stuck article(s)</strong> detected (writing status for 10+ min with no content). Click "Run Cycle Now" to auto-fix.</li>
            <?php endif; ?>
            <?php if ($stats['stuck_spheres'] > 0): ?>
                <li><strong><?php echo $stats['stuck_spheres']; ?> sphere(s)</strong> have had no activity for 30+ minutes. Click "Run Cycle Now" to continue.</li>
            <?php endif; ?>
        </ul>
        <p style="margin: 10px 0 0 0; font-size: 12px; color: #856404;">
            💡 <strong>Tip:</strong> For fully autonomous operation, ensure Auto-Run is enabled and your hosting has reliable WP-Cron or a real server cron job.
        </p>
    </div>
    <?php endif; ?>
    
    <div class="aiab-dashboard-grid">
        <!-- Stats Cards -->
        <div class="aiab-stats-row">
            <div class="aiab-stat-card">
                <div class="aiab-stat-icon">👤</div>
                <div class="aiab-stat-content">
                    <span class="aiab-stat-number"><?php echo esc_html($stats['active_personas']); ?></span>
                    <span class="aiab-stat-label">Active Personas</span>
                </div>
            </div>
            
            <div class="aiab-stat-card">
                <div class="aiab-stat-icon">🌐</div>
                <div class="aiab-stat-content">
                    <span class="aiab-stat-number"><?php echo esc_html($stats['completed_spheres']); ?></span>
                    <span class="aiab-stat-label">Thought Spheres</span>
                </div>
            </div>
            
            <div class="aiab-stat-card">
                <div class="aiab-stat-icon">📝</div>
                <div class="aiab-stat-content">
                    <span class="aiab-stat-number"><?php echo esc_html($stats['published_articles']); ?></span>
                    <span class="aiab-stat-label">Published Articles</span>
                </div>
            </div>
            
            <div class="aiab-stat-card">
                <div class="aiab-stat-icon">📈</div>
                <div class="aiab-stat-content">
                    <span class="aiab-stat-number"><?php echo esc_html($stats['articles_this_week']); ?></span>
                    <span class="aiab-stat-label">This Week</span>
                </div>
            </div>
        </div>
        
        <!-- Main Content Area -->
        <div class="aiab-dashboard-main">
            <!-- Current Status -->
            <div class="aiab-card">
                <h2>⚡ Current Status</h2>
                
                <?php if ($stats['in_progress']): ?>
                    <div class="aiab-status-active">
                        <div class="aiab-status-indicator pulse"></div>
                        <div class="aiab-status-info">
                            <strong>Sphere In Progress:</strong> <?php echo esc_html($stats['in_progress']->pillar_keyword); ?><br>
                            <span class="aiab-status-phase">Phase: <?php echo esc_html(ucwords(str_replace('_', ' ', $stats['in_progress']->phase))); ?></span>
                            <span class="aiab-status-progress"><?php echo esc_html($stats['in_progress']->completed_articles); ?>/<?php echo esc_html($stats['in_progress']->total_articles); ?> articles</span>
                        </div>
                    </div>
                <?php else: ?>
                    <?php 
                    // Check if there's a stale lock
                    $lock = get_option('aiab_orchestrator_lock');
                    $lock_data = $lock ? json_decode($lock, true) : null;
                    $is_locked = !empty($lock_data);
                    $lock_age = $is_locked && isset($lock_data['time']) ? human_time_diff($lock_data['time']) : '';
                    ?>
                    <?php if ($is_locked): ?>
                        <div class="aiab-status-idle" style="background: #fff3cd; border-left-color: #ffc107;">
                            <div class="aiab-status-indicator" style="background: #ffc107;"></div>
                            <span>🔒 <strong>Process locked</strong> (<?php echo esc_html($lock_age); ?> ago) - A cycle may be running. Click "Clear Lock" if stuck.</span>
                        </div>
                    <?php else: ?>
                        <div class="aiab-status-idle">
                            <div class="aiab-status-indicator"></div>
                            <span>System idle - waiting for next scheduled run</span>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                
                <div class="aiab-next-run">
                    <strong>Next Scheduled Run:</strong>
                    <?php if ($next_run): ?>
                        <?php 
                        $timezone = get_option('aiab_timezone', 'UTC');
                        $dt = new DateTime('@' . $next_run);
                        $dt->setTimezone(new DateTimeZone($timezone));
                        echo esc_html($dt->format('M j, Y g:i A T')); 
                        ?>
                        <span class="aiab-time-relative">(<?php echo esc_html(human_time_diff($next_run)); ?> from now)</span>
                    <?php else: ?>
                        <span class="aiab-warning">Not scheduled</span>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Manual Trigger -->
            <div class="aiab-card">
                <h2>🚀 Manual Trigger</h2>
                <p>Run the autoblogger cycle manually. This will continue any in-progress sphere or start a new one.</p>
                
                <div class="aiab-manual-controls">
                    <select id="aiab-persona-select">
                        <option value="">Auto-select persona (round-robin)</option>
                        <?php foreach ($personas as $persona): ?>
                            <option value="<?php echo esc_attr($persona->get_id()); ?>">
                                <?php echo esc_html($persona->get_name()); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    
                    <button type="button" id="aiab-manual-run" class="button button-primary button-hero">
                        ▶️ Run Cycle Now
                    </button>
                    
                    <button type="button" id="aiab-clear-lock" class="button" style="margin-left: 10px;" title="Use if a cycle is stuck">
                        🔓 Clear Lock
                    </button>
                    
                    <button type="button" id="aiab-kill-zombies" class="button" style="margin-left: 10px; background: #dc3545; color: white; border-color: #dc3545;" title="Stop all running cycles and reset">
                        💀 Kill All Zombies
                    </button>
                </div>
                
                <div style="margin-top: 15px; padding: 12px; background: <?php echo get_option('aiab_auto_continue_enabled', 0) ? '#e8f5e9' : '#f5f5f5'; ?>; border-radius: 6px; border: 1px solid <?php echo get_option('aiab_auto_continue_enabled', 0) ? '#4caf50' : '#ddd'; ?>;">
                    <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                        <input type="checkbox" id="aiab-auto-continue" <?php checked(get_option('aiab_auto_continue_enabled', 0), 1); ?>>
                        <span style="font-weight: 500;">🔄 Auto-continue until sphere complete</span>
                    </label>
                    <p style="margin: 8px 0 0 28px; font-size: 12px; color: #666;">
                        <?php if (get_option('aiab_ai_provider') === 'walter'): ?>
                            <strong style="color: #2e7d32;">Recommended for Custom Server!</strong> Keeps running cycles until all articles are written. Uncheck anytime to stop.
                        <?php else: ?>
                            Automatically runs the next cycle when one completes. Useful for batch processing.
                        <?php endif; ?>
                    </p>
                </div>
                
                <div id="aiab-run-status" class="aiab-run-status hidden">
                    <div class="aiab-spinner"></div>
                    <span>Running cycle... This may take several minutes.</span>
                </div>
                
                <div id="aiab-run-result" class="aiab-run-result hidden"></div>
            </div>
            
            <!-- Cron Control Panel -->
            <div class="aiab-card">
                <h2>⏰ Cron Scheduler</h2>
                <?php 
                $cron_scheduled = wp_next_scheduled('aiab_run_autoblogger');
                $current_schedule = get_option('aiab_cron_schedule', 'daily');
                $cron_enabled = !empty($cron_scheduled);
                
                // Get schedule label
                $schedule_labels = array(
                    'hourly' => 'Every Hour',
                    'every_six_hours' => 'Every 6 Hours', 
                    'twice_daily' => 'Twice Daily',
                    'daily' => 'Once Daily',
                    'weekly' => 'Once Weekly'
                );
                $schedule_label = isset($schedule_labels[$current_schedule]) ? $schedule_labels[$current_schedule] : $current_schedule;
                ?>
                
                <div class="aiab-cron-status" style="display: flex; align-items: center; gap: 15px; margin-bottom: 15px; padding: 15px; border-radius: 8px; <?php echo $cron_enabled ? 'background: #d4edda; border: 1px solid #c3e6cb;' : 'background: #f8d7da; border: 1px solid #f5c6cb;'; ?>">
                    <div style="font-size: 32px;"><?php echo $cron_enabled ? '✅' : '❌'; ?></div>
                    <div>
                        <strong style="font-size: 16px;"><?php echo $cron_enabled ? 'Cron is ACTIVE' : 'Cron is DISABLED'; ?></strong><br>
                        <?php if ($cron_enabled): ?>
                            <span>Schedule: <strong><?php echo esc_html($schedule_label); ?></strong></span><br>
                            <span>Next run: <strong><?php 
                                $timezone = get_option('aiab_timezone', 'UTC');
                                $dt = new DateTime('@' . $cron_scheduled);
                                $dt->setTimezone(new DateTimeZone($timezone));
                                echo esc_html($dt->format('M j, Y g:i A T')); 
                            ?></strong> (<?php echo esc_html(human_time_diff($cron_scheduled)); ?> from now)</span>
                        <?php else: ?>
                            <span style="color: #721c24;">The autoblogger will NOT run automatically until cron is enabled.</span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="aiab-cron-controls" style="display: flex; gap: 10px; flex-wrap: wrap; align-items: center;">
                    <?php if ($cron_enabled): ?>
                        <button type="button" id="aiab-disable-cron" class="button" style="background: #dc3545; color: white; border-color: #dc3545;">
                            ⏸️ Disable Auto-Run
                        </button>
                    <?php else: ?>
                        <button type="button" id="aiab-enable-cron" class="button button-primary">
                            ▶️ Enable Auto-Run
                        </button>
                    <?php endif; ?>
                    
                    <select id="aiab-cron-schedule-select" style="min-width: 150px;">
                        <option value="hourly" <?php selected($current_schedule, 'hourly'); ?>>Every Hour</option>
                        <option value="every_six_hours" <?php selected($current_schedule, 'every_six_hours'); ?>>Every 6 Hours</option>
                        <option value="twice_daily" <?php selected($current_schedule, 'twice_daily'); ?>>Twice Daily</option>
                        <option value="daily" <?php selected($current_schedule, 'daily'); ?>>Once Daily</option>
                        <option value="weekly" <?php selected($current_schedule, 'weekly'); ?>>Once Weekly</option>
                    </select>
                    
                    <button type="button" id="aiab-reschedule-cron" class="button">
                        🔄 Update Schedule
                    </button>
                </div>
                
                <div id="aiab-cron-result" style="margin-top: 10px;"></div>
                
                <div style="margin-top: 15px; padding: 10px; background: #f8f9fa; border-radius: 4px; font-size: 12px; color: #666;">
                    <strong>ℹ️ How it works:</strong> When cron is enabled, WordPress will automatically trigger a cycle at the scheduled interval. 
                    Each cycle writes one article, so a 7-article sphere takes 7+ cycles to complete. 
                    <br><br>
                    <?php 
                    $continuation_scheduled = wp_next_scheduled('aiab_continuation_check');
                    $provider = get_option('aiab_ai_provider', 'anthropic');
                    $walter_continuous = get_option('aiab_walter_continuous_mode', 1);
                    $is_walter_mode = ($provider === 'walter' && $walter_continuous);
                    
                    if ($continuation_scheduled): 
                    ?>
                    <div style="margin: 10px 0; padding: 8px; background: <?php echo $is_walter_mode ? '#e8f5e9' : '#d4edda'; ?>; border-radius: 4px; color: <?php echo $is_walter_mode ? '#2e7d32' : '#155724'; ?>;">
                        <?php if ($is_walter_mode): ?>
                            <strong>🖥️ Custom Server Continuous Mode:</strong> ACTIVE<br>
                            <span style="font-size: 11px;">System checks every <strong>2 minutes</strong> for incomplete work and automatically continues until sphere is complete. 
                            Server will keep writing until done — no manual intervention needed!</span>
                        <?php else: ?>
                            <strong>🔄 Autonomous Continuation:</strong> ACTIVE<br>
                            <span style="font-size: 11px;">System checks every 5 minutes for incomplete work and automatically continues. 
                            If a sphere times out mid-cycle, it will resume automatically within 5 minutes.</span>
                        <?php endif; ?>
                    </div>
                    <?php else: ?>
                    <div style="margin: 10px 0; padding: 8px; background: #fff3cd; border-radius: 4px; color: #856404;">
                        <strong>🔄 Autonomous Continuation:</strong> Not Scheduled<br>
                        <span style="font-size: 11px;">Deactivate and reactivate the plugin to enable automatic continuation checks.</span>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($is_walter_mode): ?>
                    <?php 
                    $sphere_schedule = get_option('aiab_sphere_schedule', 'daily');
                    $sphere_labels = array(
                        'daily' => 'Once Daily',
                        'twice_daily' => 'Twice Daily',
                        'every_three_hours' => 'Every 3 Hours',
                        'every_six_hours' => 'Every 6 Hours',
                        'weekly' => 'Weekly'
                    );
                    ?>
                    <div style="margin: 10px 0; padding: 8px; background: #e3f2fd; border-radius: 4px; color: #1565c0;">
                        <strong>📅 Sphere Schedule:</strong> <?php echo esc_html($sphere_labels[$sphere_schedule] ?? $sphere_schedule); ?><br>
                        <span style="font-size: 11px;">New thought spheres are created on this schedule. Current sphere will be completed first regardless of time.</span>
                    </div>
                    <?php endif; ?>
                    
                    <strong>⚠️ WP-Cron Note:</strong> WordPress cron only runs when someone visits your site. For reliable scheduling, 
                    <a href="https://developer.wordpress.org/plugins/cron/hooking-wp-cron-into-the-system-task-scheduler/" target="_blank">set up a real server cron</a> 
                    that hits <code><?php echo esc_html(site_url('/wp-cron.php')); ?></code> every few minutes.
                </div>
            </div>
            
            <!-- SERVER CRON REQUIREMENTS -->
            <div class="aiab-card" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a87 100%); color: white;">
                <h2 style="color: white; border-bottom: 1px solid rgba(255,255,255,0.2); padding-bottom: 10px;">
                    🖥️ Server Cron Setup (Required for Autonomous Operation)
                </h2>
                <?php
                // Determine cron interval based on Walter mode
                $cron_provider = get_option('aiab_ai_provider', 'anthropic');
                $cron_walter_continuous = get_option('aiab_walter_continuous_mode', 1);
                $cron_is_walter = ($cron_provider === 'walter' && $cron_walter_continuous);
                $cron_interval = $cron_is_walter ? '2' : '5';
                $cron_interval_text = $cron_is_walter ? '2 minutes (Custom Server Mode)' : '5 minutes';
                ?>
                <p style="opacity: 0.9;">For truly "forever running" autonomous operation, set up a server-side cron job. This ensures the plugin runs even when no one visits your site.</p>
                
                <?php if ($cron_is_walter): ?>
                <div style="background: rgba(76,175,80,0.3); padding: 10px; border-radius: 4px; margin-bottom: 15px; border-left: 3px solid #4caf50;">
                    <strong>🖥️ Custom Server Mode Detected!</strong> Using 2-minute intervals for faster article completion.
                </div>
                <?php endif; ?>
                
                <div style="background: rgba(0,0,0,0.2); padding: 15px; border-radius: 8px; margin: 15px 0;">
                    <h4 style="color: #ffc107; margin: 0 0 10px 0;">📋 Add this cron job to your server:</h4>
                    
                    <div style="margin-bottom: 15px;">
                        <label style="display: block; color: #9cd7ff; font-size: 11px; margin-bottom: 5px;">
                            1️⃣ REQUIRED: Main WP-Cron Trigger (every <?php echo $cron_interval_text; ?>)
                        </label>
                        <code style="display: block; background: #000; padding: 10px; border-radius: 4px; font-size: 11px; color: #0f0; word-break: break-all; user-select: all;">*/<?php echo $cron_interval; ?> * * * * wget -q -O /dev/null "<?php echo esc_html(site_url('/wp-cron.php?doing_wp_cron')); ?>" >/dev/null 2>&1</code>
                    </div>
                    
                    <div style="margin-bottom: 15px;">
                        <label style="display: block; color: #9cd7ff; font-size: 11px; margin-bottom: 5px;">
                            Alternative using curl:
                        </label>
                        <code style="display: block; background: #000; padding: 10px; border-radius: 4px; font-size: 11px; color: #0f0; word-break: break-all; user-select: all;">*/<?php echo $cron_interval; ?> * * * * curl -s "<?php echo esc_html(site_url('/wp-cron.php?doing_wp_cron')); ?>" >/dev/null 2>&1</code>
                    </div>
                    
                    <div>
                        <label style="display: block; color: #9cd7ff; font-size: 11px; margin-bottom: 5px;">
                            Alternative using WP-CLI (if available):
                        </label>
                        <code style="display: block; background: #000; padding: 10px; border-radius: 4px; font-size: 11px; color: #0f0; word-break: break-all; user-select: all;">*/<?php echo $cron_interval; ?> * * * * cd <?php echo esc_html(ABSPATH); ?> && wp cron event run --due-now >/dev/null 2>&1</code>
                    </div>
                </div>
                
                <div style="background: rgba(255,193,7,0.2); padding: 10px; border-radius: 4px; border-left: 3px solid #ffc107;">
                    <strong style="color: #ffc107;">💡 Pro Tips:</strong>
                    <ul style="margin: 5px 0 0 20px; padding: 0; opacity: 0.9; font-size: 12px;">
                        <li>Add <code style="background: rgba(0,0,0,0.3); padding: 2px 5px;">define('DISABLE_WP_CRON', true);</code> to wp-config.php when using server cron</li>
                        <li>The <?php echo $cron_interval; ?>-minute interval ensures paused work resumes quickly<?php echo $cron_is_walter ? ' (optimized for local server inference)' : ''; ?></li>
                        <li>If using cPanel, add cron jobs in "Cron Jobs" section</li>
                        <li>If using Plesk, go to "Scheduled Tasks"</li>
                    </ul>
                </div>
                
                <div style="margin-top: 15px; padding: 10px; background: rgba(255,255,255,0.1); border-radius: 4px;">
                    <strong>🔍 Current Cron Status:</strong>
                    <ul style="margin: 5px 0 0 15px; padding: 0; font-size: 12px;">
                        <li>Main Autoblogger: <?php echo wp_next_scheduled('aiab_run_autoblogger') ? '✅ Scheduled' : '❌ Not Scheduled'; ?></li>
                        <li>Continuation Check (<?php echo $cron_interval; ?>min): <?php echo wp_next_scheduled('aiab_continuation_check') ? '✅ Active' : '❌ Not Active'; ?></li>
                        <li>DISABLE_WP_CRON: <?php echo defined('DISABLE_WP_CRON') && DISABLE_WP_CRON ? '✅ Set (Good!)' : '⚠️ Not Set'; ?></li>
                    </ul>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="aiab-card">
                <h2>⚙️ Quick Actions</h2>
                <div class="aiab-quick-actions">
                    <a href="<?php echo admin_url('admin.php?page=aiab-personas'); ?>" class="button">
                        👤 Manage Personas
                    </a>
                    <a href="<?php echo admin_url('admin.php?page=aiab-spheres'); ?>" class="button">
                        🌐 View Spheres
                    </a>
                    <a href="<?php echo admin_url('admin.php?page=aiab-settings'); ?>" class="button">
                        ⚙️ Settings
                    </a>
                    <a href="<?php echo admin_url('admin.php?page=aiab-logs'); ?>" class="button">
                        📋 View Logs
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Sidebar -->
        <div class="aiab-dashboard-sidebar">
            <!-- Active Personas -->
            <div class="aiab-card">
                <h3>👥 Active Personas</h3>
                <?php if (empty($personas)): ?>
                    <p class="aiab-empty">No personas configured yet.</p>
                    <a href="<?php echo admin_url('admin.php?page=aiab-personas'); ?>" class="button">Create First Persona</a>
                <?php else: ?>
                    <ul class="aiab-persona-list">
                        <?php foreach ($personas as $persona): ?>
                            <li>
                                <strong><?php echo esc_html($persona->get_name()); ?></strong>
                                <span class="aiab-persona-stats">
                                    <?php echo esc_html($persona->get_total_spheres()); ?> spheres · 
                                    <?php echo esc_html($persona->get_total_articles()); ?> articles
                                </span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    <div style="background: #f0f7ff; border-left: 3px solid #0073aa; padding: 10px; margin-top: 12px; border-radius: 4px; font-size: 12px;">
                        <strong>💡 Tip:</strong> Create a WordPress user with the same name as your persona to display the persona name as the article author.
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- System Health -->
            <div class="aiab-card">
                <h3>💚 System Health</h3>
                <ul class="aiab-health-list">
                    <li class="<?php echo get_option('aiab_anthropic_api_key') || get_option('aiab_openai_api_key') ? 'healthy' : 'warning'; ?>">
                        AI API Key: <?php echo get_option('aiab_anthropic_api_key') || get_option('aiab_openai_api_key') ? '✅ Configured' : '⚠️ Not set'; ?>
                    </li>
                    <li class="<?php 
                        $img_provider = get_option('aiab_image_provider', 'dalle');
                        $img_ok = ($img_provider === 'none') || 
                                  ($img_provider === 'dalle' && get_option('aiab_openai_api_key')) ||
                                  ($img_provider === 'stability' && get_option('aiab_stability_api_key'));
                        echo $img_ok ? 'healthy' : 'warning'; 
                    ?>">
                        Image Gen: <?php 
                        if ($img_provider === 'none') {
                            echo '⏸️ Disabled';
                        } elseif ($img_ok) {
                            echo '✅ Ready (' . ($img_provider === 'dalle' ? 'DALL-E' : 'Stability') . ')';
                        } else {
                            echo '⚠️ Missing ' . ($img_provider === 'dalle' ? 'OpenAI' : 'Stability') . ' key';
                        }
                        ?>
                    </li>
                    <li class="<?php echo $stats['active_personas'] > 0 ? 'healthy' : 'warning'; ?>">
                        Personas: <?php echo $stats['active_personas'] > 0 ? '✅ ' . $stats['active_personas'] . ' active' : '⚠️ None active'; ?>
                    </li>
                    <li class="<?php echo $next_run ? 'healthy' : 'warning'; ?>">
                        Cron: <?php echo $next_run ? '✅ Scheduled' : '⚠️ Not scheduled'; ?>
                    </li>
                </ul>
            </div>
            
            <!-- AI Provider Diagnostic -->
            <div class="aiab-card" style="background: #f0f7ff; border: 1px solid #0073aa;">
                <h3>🔧 AI Provider Debug</h3>
                <p style="font-size: 11px; color: #666; margin-bottom: 10px;">
                    Actual values stored in database:
                </p>
                <?php
                $db_provider = get_option('aiab_ai_provider', 'NOT SET');
                // Get the correct model based on provider
                if ($db_provider === 'walter') {
                    $db_model = get_option('aiab_walter_model', 'NOT SET');
                    $walter_url = get_option('aiab_walter_url', 'NOT SET');
                } else {
                    $db_model = get_option('aiab_ai_model', 'NOT SET');
                }
                $anthropic_key = get_option('aiab_anthropic_api_key', '');
                $openai_key = get_option('aiab_openai_api_key', '');
                $perplexity_key = get_option('aiab_perplexity_api_key', '');
                
                // Detect key types
                $key_info = array();
                if (!empty($anthropic_key)) {
                    $key_info[] = 'Anthropic: ' . substr($anthropic_key, 0, 10) . '...';
                }
                if (!empty($openai_key)) {
                    $key_info[] = 'OpenAI: ' . substr($openai_key, 0, 10) . '...';
                }
                if (!empty($perplexity_key)) {
                    $key_info[] = 'Perplexity: ' . substr($perplexity_key, 0, 10) . '...';
                }
                
                // Check for mismatch (Walter doesn't need API key)
                $expected_key = '';
                $is_walter = ($db_provider === 'walter');
                if ($db_provider === 'anthropic') {
                    $expected_key = $anthropic_key;
                } elseif ($db_provider === 'openai') {
                    $expected_key = $openai_key;
                } elseif ($db_provider === 'perplexity') {
                    $expected_key = $perplexity_key;
                } elseif ($is_walter) {
                    $expected_key = 'walter-local'; // Walter doesn't need API key
                }
                $has_mismatch = empty($expected_key) && !empty($key_info) && !$is_walter;
                ?>
                <ul style="font-size: 12px; margin: 0; padding-left: 15px;">
                    <li><strong>Provider:</strong> <code><?php echo esc_html($db_provider); ?></code></li>
                    <li><strong>Model:</strong> <code><?php echo esc_html($db_model); ?></code></li>
                    <?php if ($is_walter): ?>
                        <li><strong>Server URL:</strong> <code><?php echo esc_html($walter_url); ?></code></li>
                    <?php endif; ?>
                    <li><strong>Keys Found:</strong>
                        <?php if (empty($key_info)): ?>
                            <span style="color: #666;"><?php echo $is_walter ? 'N/A (Custom Server uses local Ollama)' : '<span style="color: #dc3545;">None!</span>'; ?></span>
                        <?php else: ?>
                            <ul style="margin: 5px 0 0 0; padding-left: 15px;">
                                <?php foreach ($key_info as $ki): ?>
                                    <li><code style="font-size: 10px;"><?php echo esc_html($ki); ?></code></li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </li>
                </ul>
                <?php if ($is_walter): ?>
                    <div style="margin-top: 10px; padding: 8px; background: #e8f5e9; border-radius: 4px; color: #2e7d32; font-size: 11px;">
                        <strong>🖥️ Custom Server:</strong> Using local Ollama server (no API key needed)
                    </div>
                <?php elseif ($has_mismatch): ?>
                    <div style="margin-top: 10px; padding: 8px; background: #fff3cd; border-radius: 4px; color: #856404; font-size: 11px;">
                        <strong>⚠️ MISMATCH:</strong> Provider is set to "<?php echo esc_html($db_provider); ?>" but that API key is empty!
                        <br>Available keys: <?php echo esc_html(implode(', ', array_map(function($k) { return explode(':', $k)[0]; }, $key_info))); ?>
                    </div>
                <?php elseif (empty($expected_key)): ?>
                    <div style="margin-top: 10px; padding: 8px; background: #f8d7da; border-radius: 4px; color: #721c24; font-size: 11px;">
                        <strong>❌ NO API KEY:</strong> The selected provider has no API key configured.
                    </div>
                <?php else: ?>
                    <div style="margin-top: 10px; padding: 8px; background: #d4edda; border-radius: 4px; color: #155724; font-size: 11px;">
                        <strong>✅ OK:</strong> Provider and API key match.
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Cost Estimator -->
            <div class="aiab-card" style="background: #fff8e6; border: 1px solid #f0ad4e;">
                <h3>💰 Cost Estimator</h3>
                <?php
                $provider = get_option('aiab_ai_provider', 'anthropic');
                if ($provider === 'walter') {
                    $model = get_option('aiab_walter_model', 'local-model');
                } else {
                    $model = get_option('aiab_ai_model', 'claude-sonnet-4-20250514');
                }
                $articles_per_sphere = intval(get_option('aiab_articles_per_sphere', 7));
                $budget_mode = get_option('aiab_budget_mode', 0);
                $skip_research = get_option('aiab_skip_research_ai', 0);
                
                // Token estimates per sphere
                $research_tokens = $skip_research ? 100 : ($budget_mode ? 1600 : 2600);
                $pillar_tokens = $budget_mode ? 5000 : 8192;
                $cluster_tokens = $budget_mode ? 3500 : 6000;
                $cluster_count = max(0, $articles_per_sphere - 1);
                
                $total_output = $research_tokens + $pillar_tokens + ($cluster_tokens * $cluster_count);
                $total_input = $budget_mode ? ($total_output * 0.15) : ($total_output * 0.3); // Prompts
                
                // Cost per 1M tokens (approximate)
                $costs = array(
                    'anthropic' => array(
                        'claude-sonnet-4-20250514' => array('input' => 3, 'output' => 15),
                        'claude-opus-4-20250514' => array('input' => 15, 'output' => 75),
                        'claude-3-5-haiku-20241022' => array('input' => 0.25, 'output' => 1.25),
                    ),
                    'openai' => array(
                        'gpt-4-turbo-preview' => array('input' => 10, 'output' => 30),
                        'gpt-4' => array('input' => 30, 'output' => 60),
                    ),
                    'perplexity' => array(
                        'sonar' => array('input' => 1, 'output' => 1),
                        'sonar-pro' => array('input' => 3, 'output' => 15),
                    ),
                    'walter' => array(), // Free!
                );
                
                $is_walter = ($provider === 'walter');
                $rate = isset($costs[$provider][$model]) ? $costs[$provider][$model] : array('input' => 3, 'output' => 15);
                $cost_per_sphere = $is_walter ? 0 : (($total_input / 1000000) * $rate['input']) + (($total_output / 1000000) * $rate['output']);
                ?>
                <?php if ($is_walter): ?>
                    <div style="font-size: 20px; font-weight: bold; color: #28a745; margin-bottom: 10px;">
                        $0.00 <span style="font-size: 12px; font-weight: normal;">FREE with Custom Server!</span>
                    </div>
                    <p style="font-size: 11px; color: #666; margin-bottom: 8px;">
                        🖥️ Using your local Ollama server — unlimited articles at no cost!
                    </p>
                <?php else: ?>
                    <p style="font-size: 11px; color: #666; margin-bottom: 8px;">
                        Estimated cost per thought sphere:
                    </p>
                    <div style="font-size: 20px; font-weight: bold; color: #856404; margin-bottom: 10px;">
                        ~$<?php echo number_format($cost_per_sphere, 2); ?> <span style="font-size: 12px; font-weight: normal;">per sphere</span>
                    </div>
                <?php endif; ?>
                <ul style="font-size: 11px; margin: 0; padding-left: 15px; color: #666;">
                    <li>Articles: <?php echo $articles_per_sphere; ?> (1 pillar + <?php echo $cluster_count; ?> cluster)</li>
                    <li>Output tokens: ~<?php echo number_format($total_output); ?></li>
                    <li>Input tokens: ~<?php echo number_format($total_input); ?></li>
                    <?php if (!$is_walter): ?>
                        <li>Budget mode: <?php echo $budget_mode ? '✅ ON (-40%)' : '❌ OFF'; ?></li>
                        <li>Skip AI research: <?php echo $skip_research ? '✅ ON' : '❌ OFF'; ?></li>
                    <?php endif; ?>
                </ul>
                <?php if (!$is_walter): ?>
                    <p style="font-size: 10px; color: #999; margin-top: 8px; margin-bottom: 0;">
                        💡 Tip: Enable Budget Mode in Settings to reduce costs by ~40%
                    </p>
                <?php else: ?>
                    <p style="font-size: 10px; color: #999; margin-top: 8px; margin-bottom: 0;">
                        ⚡ Note: CPU inference is slower but runs 24/7 for free
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Support Section -->
    <div class="aiab-card" style="margin-top: 20px; background: #f8f9fa; border: 1px solid #e9ecef;">
        <h2 style="margin-top: 0;">💬 Need Help?</h2>
        <p>We're here to help you get the most out of Eternal Auto Blogger!</p>
        <div style="display: flex; flex-wrap: wrap; gap: 15px; margin-top: 15px;">
            <a href="https://eternalautoblogger.com/#contact" target="_blank" class="button button-secondary" style="display: inline-flex; align-items: center; gap: 8px; padding: 10px 20px;">
                📝 Contact Form
            </a>
            <a href="mailto:help@eternalautoblogger.com" class="button button-secondary" style="display: inline-flex; align-items: center; gap: 8px; padding: 10px 20px;">
                ✉️ help@eternalautoblogger.com
            </a>
            <a href="https://eternalautoblogger.com/docs" target="_blank" class="button button-secondary" style="display: inline-flex; align-items: center; gap: 8px; padding: 10px 20px;">
                📚 Documentation
            </a>
        </div>
    </div>
</div>
