<?php
/**
 * Personas View
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap aiab-wrap">
    <h1>👤 AI Personas</h1>
    <p>Create and manage AI author personas. Each persona has unique interests, expertise, and writing style.</p>
    
    <?php
    // FREE VERSION: Check persona limit (1 persona max)
    $persona_count = count($personas);
    $persona_limit = 1;
    $limit_reached = !$editing && $persona_count >= $persona_limit;
    ?>
    
    <?php if ($limit_reached): ?>
    <div class="aiab-limit-banner" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; margin-bottom: 20px; border-radius: 8px; display: flex; flex-wrap: wrap; align-items: center; gap: 20px;">
        <div style="flex: 1; min-width: 250px;">
            <h3 style="margin: 0 0 10px 0; color: white;">📊 Persona Limit Reached</h3>
            <p style="margin: 0; opacity: 0.95;">
                The free version allows <strong>1 persona</strong>. You can edit your existing persona or upgrade to Pro for unlimited personas.
            </p>
        </div>
        <div>
            <a href="https://eternalautoblogger.com" target="_blank" class="button" style="background: white; color: #667eea; border: none; font-weight: bold; padding: 12px 25px; font-size: 14px; border-radius: 6px;">
                🚀 Upgrade to Pro - Unlimited Personas
            </a>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="aiab-personas-container">
        <!-- Persona Form -->
        <?php if (!$limit_reached): ?>
        <div class="aiab-card aiab-persona-form-card">
            <h2><?php echo $editing ? '✏️ Edit Persona' : '➕ Create New Persona'; ?></h2>
            
            <form id="aiab-persona-form" class="aiab-persona-form">
                <input type="hidden" name="id" value="<?php echo $editing ? esc_attr($editing->get_id()) : ''; ?>">
                
                <div class="aiab-form-row">
                    <label for="persona-name">Persona Name *</label>
                    <input type="text" id="persona-name" name="name" required
                           value="<?php echo $editing ? esc_attr($editing->get_name()) : ''; ?>"
                           placeholder="e.g., Tech Enthusiast, Health Coach, Finance Expert">
                </div>
                
                <div class="aiab-form-row">
                    <label for="persona-story">📖 Personal Story <small>(Your unique background and journey)</small></label>
                    <textarea id="persona-story" name="personal_story" rows="6"
                              placeholder="Tell the story of this persona... For example:

I started my journey in tech back in 2010 when I built my first website in my college dorm room. After spending 8 years as a software engineer at major tech companies, I burned out and took a year off to travel. That experience taught me the importance of work-life balance and led me to become passionate about helping others avoid the same mistakes I made. Now I write about sustainable productivity, mindful technology use, and building careers that don't sacrifice your wellbeing."><?php 
                        echo $editing ? esc_textarea($editing->get_personal_story()) : ''; 
                    ?></textarea>
                    <p class="description">This backstory shapes how the AI writes - it will reference personal experiences, lessons learned, and unique perspectives from this story.</p>
                </div>
                
                <div class="aiab-form-row">
                    <label for="persona-expertise">Expertise Areas * <small>(one per line)</small></label>
                    <textarea id="persona-expertise" name="expertise_areas" rows="4" required
                              placeholder="e.g.,&#10;Artificial Intelligence&#10;Machine Learning&#10;Data Science"><?php 
                        echo $editing ? esc_textarea(implode("\n", $editing->get_expertise_areas())) : ''; 
                    ?></textarea>
                </div>
                
                <div class="aiab-form-row">
                    <label for="persona-interests">Interests <small>(one per line)</small></label>
                    <textarea id="persona-interests" name="interests" rows="4"
                              placeholder="e.g.,&#10;Emerging technologies&#10;Startup culture&#10;Productivity tools"><?php 
                        echo $editing ? esc_textarea(implode("\n", $editing->get_interests())) : ''; 
                    ?></textarea>
                </div>
                
                <div class="aiab-form-row">
                    <label for="persona-passions">Passions <small>(one per line)</small></label>
                    <textarea id="persona-passions" name="passions" rows="3"
                              placeholder="e.g.,&#10;Making complex topics accessible&#10;Helping beginners learn"><?php 
                        echo $editing ? esc_textarea(implode("\n", $editing->get_passions())) : ''; 
                    ?></textarea>
                </div>
                
                <div class="aiab-form-grid">
                    <div class="aiab-form-row">
                        <label for="persona-voice">Voice Style</label>
                        <select id="persona-voice" name="voice_style">
                            <?php 
                            $voices = array('professional', 'casual', 'academic', 'friendly', 'authoritative', 'conversational');
                            $current_voice = $editing ? $editing->get_voice_style() : 'professional';
                            foreach ($voices as $voice): ?>
                                <option value="<?php echo esc_attr($voice); ?>" <?php selected($current_voice, $voice); ?>>
                                    <?php echo esc_html(ucfirst($voice)); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="aiab-form-row">
                        <label for="persona-tone">Tone</label>
                        <select id="persona-tone" name="tone">
                            <?php 
                            $tones = array('informative', 'inspiring', 'practical', 'analytical', 'enthusiastic', 'balanced');
                            $current_tone = $editing ? $editing->get_tone() : 'informative';
                            foreach ($tones as $tone): ?>
                                <option value="<?php echo esc_attr($tone); ?>" <?php selected($current_tone, $tone); ?>>
                                    <?php echo esc_html(ucfirst($tone)); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                
                <div class="aiab-form-row">
                    <label for="persona-audience">Target Audience</label>
                    <input type="text" id="persona-audience" name="target_audience"
                           value="<?php echo $editing ? esc_attr($editing->get_target_audience()) : ''; ?>"
                           placeholder="e.g., Beginners interested in tech, Small business owners">
                </div>
                
                <div class="aiab-form-row">
                    <label for="persona-guidelines">Writing Guidelines</label>
                    <textarea id="persona-guidelines" name="writing_guidelines" rows="4"
                              placeholder="Specific instructions for writing style, formatting preferences, etc."><?php 
                        echo $editing ? esc_textarea($editing->get_writing_guidelines()) : ''; 
                    ?></textarea>
                </div>
                
                <div class="aiab-form-row">
                    <label for="persona-sources">Knowledge Sources <small>(one per line - URLs or references)</small></label>
                    <textarea id="persona-sources" name="knowledge_sources" rows="3"
                              placeholder="e.g.,&#10;https://example.com&#10;Industry reports&#10;Research papers"><?php 
                        echo $editing ? esc_textarea(implode("\n", $editing->get_knowledge_sources())) : ''; 
                    ?></textarea>
                </div>
                
                <div class="aiab-form-row">
                    <label for="persona-avoid">Topics to Avoid <small>(one per line)</small></label>
                    <textarea id="persona-avoid" name="avoid_topics" rows="2"
                              placeholder="e.g.,&#10;Political opinions&#10;Controversial topics"><?php 
                        echo $editing ? esc_textarea(implode("\n", $editing->get_avoid_topics())) : ''; 
                    ?></textarea>
                </div>
                
                <div class="aiab-form-grid">
                    <div class="aiab-form-row">
                        <label for="persona-language">Language</label>
                        <select id="persona-language" name="language">
                            <option value="en" <?php selected($editing ? $editing->get_language() : 'en', 'en'); ?>>English</option>
                            <option value="es" <?php selected($editing ? $editing->get_language() : '', 'es'); ?>>Spanish</option>
                            <option value="fr" <?php selected($editing ? $editing->get_language() : '', 'fr'); ?>>French</option>
                            <option value="de" <?php selected($editing ? $editing->get_language() : '', 'de'); ?>>German</option>
                        </select>
                    </div>
                    
                    <div class="aiab-form-row">
                        <label for="persona-active">Status</label>
                        <label class="aiab-toggle">
                            <input type="checkbox" id="persona-active" name="is_active" value="1"
                                   <?php checked($editing ? $editing->is_active() : true); ?>>
                            <span class="aiab-toggle-slider"></span>
                            <span class="aiab-toggle-label">Active</span>
                        </label>
                    </div>
                </div>
                
                <hr style="margin: 20px 0; border-color: #e2e8f0;">
                <h3 style="margin-bottom: 15px;">🌍 Geographic Targeting (Local SEO)</h3>
                
                <div class="aiab-form-row">
                    <label>Target Locations <small>(Search and add cities/regions where this persona operates)</small></label>
                    
                    <div class="aiab-localities-wrapper" style="border: 1px solid #ddd; border-radius: 8px; padding: 15px; background: #fafafa;">
                        <!-- Search Box -->
                        <div style="margin-bottom: 15px;">
                            <div style="display: flex; gap: 10px;">
                                <input type="text" 
                                       id="locality-search" 
                                       placeholder="🔍 Search for any city or region (e.g., 'Fujairah', 'Manchester', 'Tokyo')" 
                                       style="flex: 1; padding: 10px; font-size: 14px;"
                                       autocomplete="off">
                                <button type="button" id="add-locality-btn" class="button" style="padding: 10px 20px;">
                                    ➕ Add
                                </button>
                            </div>
                            <div id="locality-suggestions" style="display: none; position: absolute; z-index: 1000; background: white; border: 1px solid #ddd; border-radius: 4px; max-height: 300px; overflow-y: auto; box-shadow: 0 4px 6px rgba(0,0,0,0.1); width: calc(100% - 100px);"></div>
                        </div>
                        
                        <!-- Selected Locations -->
                        <div id="selected-localities" style="min-height: 50px; padding: 10px; background: white; border: 1px dashed #ccc; border-radius: 4px;">
                            <?php
                            $current_localities = $editing ? $editing->get_localities() : array();
                            if (empty($current_localities)): ?>
                                <p id="no-localities-msg" style="color: #999; margin: 0; text-align: center;">
                                    No locations selected. Search above or use quick-select below.
                                </p>
                            <?php else: ?>
                                <p id="no-localities-msg" style="color: #999; margin: 0; text-align: center; display: none;">
                                    No locations selected. Search above or use quick-select below.
                                </p>
                            <?php endif; ?>
                            
                            <?php foreach ($current_localities as $locality): 
                                // Parse the locality - could be code or "City, Country" format
                                $display_name = $locality;
                                $locality_code = $locality;
                            ?>
                                <span class="locality-tag" data-code="<?php echo esc_attr($locality_code); ?>" style="display: inline-flex; align-items: center; gap: 5px; background: #e3f2fd; border: 1px solid #90caf9; padding: 5px 10px; border-radius: 20px; margin: 3px; font-size: 13px;">
                                    📍 <?php echo esc_html($display_name); ?>
                                    <button type="button" class="remove-locality" style="background: none; border: none; color: #f44336; cursor: pointer; font-size: 16px; padding: 0 2px;">&times;</button>
                                    <input type="hidden" name="localities[]" value="<?php echo esc_attr($locality_code); ?>">
                                </span>
                            <?php endforeach; ?>
                        </div>
                        
                        <!-- Quick Select - Common Regions -->
                        <div style="margin-top: 15px;">
                            <p style="margin: 0 0 10px 0; font-weight: 600; font-size: 12px; color: #666;">⚡ Quick Select:</p>
                            <div style="display: flex; flex-wrap: wrap; gap: 5px;">
                                <?php
                                $quick_locations = array(
                                    // UK Cities (Primary)
                                    'London, UK' => 'London, United Kingdom',
                                    'Manchester, UK' => 'Manchester, United Kingdom',
                                    'Birmingham, UK' => 'Birmingham, United Kingdom',
                                    'Edinburgh, UK' => 'Edinburgh, United Kingdom',
                                    'Glasgow, UK' => 'Glasgow, United Kingdom',
                                    'Liverpool, UK' => 'Liverpool, United Kingdom',
                                    'Leeds, UK' => 'Leeds, United Kingdom',
                                    'Bristol, UK' => 'Bristol, United Kingdom',
                                    // UAE Emirates (Secondary)
                                    'Dubai, UAE' => 'Dubai, United Arab Emirates',
                                    'Abu Dhabi, UAE' => 'Abu Dhabi, United Arab Emirates',
                                    'Sharjah, UAE' => 'Sharjah, United Arab Emirates',
                                    'Ajman, UAE' => 'Ajman, United Arab Emirates',
                                    'Fujairah, UAE' => 'Fujairah, United Arab Emirates',
                                    'RAK, UAE' => 'Ras Al Khaimah, United Arab Emirates',
                                    // Other Major Cities
                                    'New York, USA' => 'New York, United States',
                                    'Sydney, Australia' => 'Sydney, Australia',
                                    'Singapore' => 'Singapore',
                                    'Toronto, Canada' => 'Toronto, Canada',
                                    'Paris, France' => 'Paris, France',
                                    'Doha, Qatar' => 'Doha, Qatar',
                                    'Riyadh, KSA' => 'Riyadh, Saudi Arabia',
                                );
                                foreach ($quick_locations as $short => $full): 
                                    $is_selected = in_array($full, $current_localities);
                                ?>
                                    <button type="button" 
                                            class="quick-locality <?php echo $is_selected ? 'selected' : ''; ?>" 
                                            data-location="<?php echo esc_attr($full); ?>"
                                            style="padding: 4px 10px; font-size: 11px; border-radius: 15px; border: 1px solid #ddd; background: <?php echo $is_selected ? '#4CAF50' : '#fff'; ?>; color: <?php echo $is_selected ? '#fff' : '#333'; ?>; cursor: pointer; transition: all 0.2s;">
                                        <?php echo esc_html($short); ?>
                                    </button>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        
                        <p class="description" style="margin-top: 15px;">
                            <strong>Leave empty for global reach.</strong> When locations are set, the AI will:
                            <br>• Use local currency (£, $, €, AED, etc.) and measurements
                            <br>• Write in appropriate English variant (British/American)
                            <br>• Reference local landmarks and regulations
                            <br>• Target local search queries and trends
                        </p>
                    </div>
                </div>
                
                <hr style="margin: 20px 0; border-color: #e2e8f0;">
                <h3 style="margin-bottom: 15px;">📝 WordPress Publishing Settings</h3>
                
                <div class="aiab-form-row">
                    <label for="persona-author">WordPress Author</label>
                    <select id="persona-author" name="wp_author_id">
                        <option value="">Use default author from settings</option>
                        <?php 
                        $users = get_users(array('role__in' => array('administrator', 'editor', 'author'), 'orderby' => 'display_name'));
                        $current_author = $editing ? $editing->get_wp_author_id() : '';
                        foreach ($users as $user): ?>
                            <option value="<?php echo esc_attr($user->ID); ?>" <?php selected($current_author, $user->ID); ?>>
                                <?php echo esc_html($user->display_name); ?> (<?php echo esc_html($user->user_login); ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <p class="description">Articles by this persona will be published under this WordPress author account.</p>
                    <div style="background: #e7f3ff; border-left: 4px solid #0073aa; padding: 12px; margin-top: 10px; border-radius: 4px;">
                        <strong>💡 Tip:</strong> To display the persona name as the article author, create a WordPress user with the <strong>same name as your persona</strong> and select it here. For example, if your persona is "Tanner Hunt", create a WordPress user named "Tanner Hunt" with the Author role.
                    </div>
                </div>
                
                <div class="aiab-form-row">
                    <label>Blog Categories <small>(select which categories this persona writes for)</small></label>
                    <div class="aiab-category-checklist" style="max-height: 200px; overflow-y: auto; border: 1px solid #ddd; padding: 10px; border-radius: 4px; background: #f9f9f9;">
                        <?php 
                        $categories = get_categories(array('hide_empty' => false, 'orderby' => 'name'));
                        $selected_cats = $editing ? $editing->get_categories() : array();
                        if (empty($categories)): ?>
                            <p style="color: #666;">No categories found. <a href="<?php echo admin_url('edit-tags.php?taxonomy=category'); ?>">Create categories</a> first.</p>
                        <?php else:
                            foreach ($categories as $category): ?>
                                <label style="display: block; margin-bottom: 8px; cursor: pointer;">
                                    <input type="checkbox" name="categories[]" value="<?php echo esc_attr($category->term_id); ?>"
                                           <?php checked(in_array($category->term_id, $selected_cats)); ?>>
                                    <?php echo esc_html($category->name); ?>
                                    <span style="color: #999; font-size: 0.85em;">(<?php echo esc_html($category->count); ?> posts)</span>
                                </label>
                            <?php endforeach;
                        endif; ?>
                    </div>
                    <p class="description">If no categories selected, the default category from settings will be used. If multiple categories selected, one will be randomly chosen for each article.</p>
                </div>
                
                <div class="aiab-form-actions">
                    <button type="submit" class="button button-primary button-large">
                        <?php echo $editing ? '💾 Update Persona' : '➕ Create Persona'; ?>
                    </button>
                    <?php if ($editing): ?>
                        <a href="<?php echo admin_url('admin.php?page=aiab-personas'); ?>" class="button button-large">Cancel</a>
                    <?php endif; ?>
                </div>
            </form>
        </div>
        <?php endif; // End limit_reached check ?>
        
        <!-- Personas List -->
        <div class="aiab-card aiab-personas-list-card">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h2 style="margin: 0;">📋 All Personas</h2>
                <div>
                    <button type="button" id="aiab-import-persona-btn" class="button">
                        📥 Import Persona
                    </button>
                </div>
            </div>
            
            <!-- Import Form (hidden by default) -->
            <div id="aiab-import-form" style="display: none; background: #f0f6fc; border: 2px dashed #0073aa; border-radius: 8px; padding: 20px; margin-bottom: 20px;">
                <h3 style="margin-top: 0;">📥 Import Persona from .eab file</h3>
                <p>Upload a persona file exported from another Eternal Auto Blogger installation.</p>
                <form id="aiab-import-persona-form" enctype="multipart/form-data">
                    <input type="file" name="persona_file" id="persona-import-file" accept=".eab,.zip" required 
                           style="margin-right: 10px;">
                    <button type="submit" class="button button-primary">📥 Import</button>
                    <button type="button" id="aiab-cancel-import" class="button">Cancel</button>
                </form>
                <p class="description" style="margin-top: 10px;">Supported formats: .eab (Eternal Auto Blogger persona file)</p>
            </div>
            
            <?php if (empty($personas)): ?>
                <div class="aiab-empty-state">
                    <span class="aiab-empty-icon">👤</span>
                    <p>No personas created yet. Create your first AI author persona to get started!</p>
                </div>
            <?php else: ?>
                <table class="aiab-table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Expertise</th>
                            <th>Author / Categories</th>
                            <th>Stats</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($personas as $persona): ?>
                            <tr>
                                <td>
                                    <strong><?php echo esc_html($persona->get_name()); ?></strong>
                                    <br><small><?php echo esc_html($persona->get_voice_style()); ?> · <?php echo esc_html($persona->get_tone()); ?></small>
                                </td>
                                <td>
                                    <?php 
                                    $expertise = $persona->get_expertise_areas();
                                    echo esc_html(implode(', ', array_slice($expertise, 0, 3)));
                                    if (count($expertise) > 3) echo '...';
                                    ?>
                                </td>
                                <td>
                                    <?php 
                                    $author_id = $persona->get_wp_author_id();
                                    $categories = $persona->get_categories();
                                    
                                    if ($author_id) {
                                        $author = get_user_by('ID', $author_id);
                                        echo '<strong>👤 ' . esc_html($author ? $author->display_name : 'Unknown') . '</strong><br>';
                                    } else {
                                        echo '<span style="color:#999;">👤 Default Author</span><br>';
                                    }
                                    
                                    if (!empty($categories)) {
                                        $cat_names = array();
                                        foreach ($categories as $cat_id) {
                                            $cat = get_category($cat_id);
                                            if ($cat) $cat_names[] = $cat->name;
                                        }
                                        echo '<small>📁 ' . esc_html(implode(', ', array_slice($cat_names, 0, 3)));
                                        if (count($cat_names) > 3) echo '...';
                                        echo '</small>';
                                    } else {
                                        echo '<small style="color:#999;">📁 Default Category</small>';
                                    }
                                    ?>
                                </td>
                                <td>
                                    <span class="aiab-badge"><?php echo esc_html($persona->get_total_spheres()); ?> spheres</span>
                                    <span class="aiab-badge"><?php echo esc_html($persona->get_total_articles()); ?> articles</span>
                                </td>
                                <td>
                                    <?php if ($persona->is_active()): ?>
                                        <span class="aiab-status-badge active">✅ Active</span>
                                    <?php else: ?>
                                        <span class="aiab-status-badge inactive">⏸️ Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo admin_url('admin.php?page=aiab-personas&edit=' . $persona->get_id()); ?>" 
                                       class="button button-small">Edit</a>
                                    <button type="button" class="button button-small aiab-export-persona" 
                                            data-id="<?php echo esc_attr($persona->get_id()); ?>"
                                            data-name="<?php echo esc_attr($persona->get_name()); ?>"
                                            title="Export this persona">📤 Export</button>
                                    <button type="button" class="button button-small aiab-delete-persona" 
                                            data-id="<?php echo esc_attr($persona->get_id()); ?>"
                                            data-name="<?php echo esc_attr($persona->get_name()); ?>">Delete</button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>
