<?php
/**
 * Settings View - Free Version
 */

if (!defined('ABSPATH')) {
    exit;
}

// Free version - only settings tab, no license tab
$active_tab = 'settings';
?>

<div class="wrap aiab-wrap">
    <h1>⚙️ Eternal Auto Blogger - Free Settings</h1>
    
    <!-- Settings Content -->
    <form method="post" action="options.php" class="aiab-settings-form">
        <?php settings_fields('aiab_settings'); ?>
        
        <div class="aiab-settings-grid">
            <!-- API Keys -->
            <div class="aiab-card">
                <h2>🔑 API Keys</h2>
                <p class="description">Configure your OpenAI API key for AI content generation and DALL-E images.</p>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="aiab_openai_api_key">OpenAI API Key</label>
                        </th>
                        <td>
                            <input type="password" id="aiab_openai_api_key" name="aiab_openai_api_key" 
                                   class="regular-text" value="<?php echo esc_attr(get_option('aiab_openai_api_key')); ?>">
                            <p class="description">For GPT-4 and DALL-E image generation. Get your key at <a href="https://platform.openai.com/" target="_blank">platform.openai.com</a></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Search Provider</th>
                        <td>
                            <div style="background: #e7f5e7; padding: 15px; border-radius: 6px; border-left: 4px solid #28a745;">
                                <strong>✅ Free Search - Super-Powered Research (No API Key Required!)</strong><br><br>
                                This free version uses <strong>9 data sources</strong>:
                                <ul style="margin: 10px 0 0 20px;">
                                    <li>🔍 <strong>Google Autocomplete</strong> - Real search suggestions with 20+ modifiers</li>
                                    <li>🦆 <strong>DuckDuckGo</strong> - Related topics & instant answers</li>
                                    <li>🔤 <strong>Alphabet Soup</strong> - A-Z keyword variations</li>
                                    <li>❓ <strong>Question Variations</strong> - Who, What, When, Why, How patterns</li>
                                    <li>⭐ <strong>Google PAA Scraper</strong> - "People Also Ask" questions</li>
                                    <li>💡 <strong>AnswerThePublic-style</strong> - 80+ question patterns per topic</li>
                                    <li>📚 <strong>Wikipedia Mining</strong> - Related topics & categories</li>
                                    <li>💬 <strong>Reddit Topics</strong> - Real questions from discussions</li>
                                    <li>📈 <strong>Google Trends</strong> - Trending & rising topics</li>
                                </ul>
                            </div>
                            <input type="hidden" name="aiab_search_provider" value="free">
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- AI Settings -->
            <div class="aiab-card">
                <h2>🤖 AI Configuration</h2>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">AI Provider</th>
                        <td>
                            <div style="background: #f0f7ff; padding: 12px 15px; border-radius: 6px; border-left: 4px solid #0073aa;">
                                <strong>OpenAI (GPT-4)</strong> - Powered by GPT-4 Turbo
                            </div>
                            <input type="hidden" name="aiab_ai_provider" value="openai">
                            <p class="description" style="margin-top: 10px;">
                                <a href="https://eternalautoblogger.com" target="_blank">Upgrade to Pro</a> for Anthropic Claude, Perplexity AI, and custom server support.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_ai_model">AI Model</label>
                        </th>
                        <td>
                            <select id="aiab_ai_model" name="aiab_ai_model">
                                <option value="gpt-4-turbo-preview" <?php selected(get_option('aiab_ai_model', 'gpt-4-turbo-preview'), 'gpt-4-turbo-preview'); ?>>GPT-4 Turbo (Recommended)</option>
                                <option value="gpt-4" <?php selected(get_option('aiab_ai_model'), 'gpt-4'); ?>>GPT-4</option>
                                <option value="gpt-4o" <?php selected(get_option('aiab_ai_model'), 'gpt-4o'); ?>>GPT-4o (Latest)</option>
                                <option value="gpt-4o-mini" <?php selected(get_option('aiab_ai_model'), 'gpt-4o-mini'); ?>>GPT-4o Mini (Budget)</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_image_provider">Image Provider</label>
                        </th>
                        <td>
                            <select id="aiab_image_provider" name="aiab_image_provider">
                                <option value="dalle" <?php selected(get_option('aiab_image_provider', 'dalle'), 'dalle'); ?>>DALL-E 3 (OpenAI)</option>
                                <option value="none" <?php selected(get_option('aiab_image_provider'), 'none'); ?>>Disabled</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_image_style">Image Style</label>
                        </th>
                        <td>
                            <select id="aiab_image_style" name="aiab_image_style">
                                <option value="professional" <?php selected(get_option('aiab_image_style', 'professional'), 'professional'); ?>>Professional</option>
                                <option value="artistic" <?php selected(get_option('aiab_image_style'), 'artistic'); ?>>Artistic</option>
                                <option value="minimalist" <?php selected(get_option('aiab_image_style'), 'minimalist'); ?>>Minimalist</option>
                                <option value="photographic" <?php selected(get_option('aiab_image_style'), 'photographic'); ?>>Photographic</option>
                                <option value="illustration" <?php selected(get_option('aiab_image_style'), 'illustration'); ?>>Illustration</option>
                            </select>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Content Settings -->
            <div class="aiab-card">
                <h2>📝 Content Settings</h2>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label>Articles per Sphere</label>
                        </th>
                        <td>
                            <div style="background: #f0f7ff; padding: 12px 15px; border-radius: 6px; border-left: 4px solid #0073aa;">
                                <strong>4 (1 pillar + 3 cluster)</strong> - Free Version Limit
                            </div>
                            <input type="hidden" name="aiab_articles_per_sphere" value="4">
                            <p class="description">
                                <a href="https://eternalautoblogger.com" target="_blank">Upgrade to Pro</a> for up to 10 articles per sphere.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label>Pillar Word Count</label>
                        </th>
                        <td>
                            <div style="background: #f0f7ff; padding: 12px 15px; border-radius: 6px; border-left: 4px solid #0073aa;">
                                <strong>~600 words</strong> - OpenAI Free Limit
                            </div>
                            <input type="hidden" name="aiab_pillar_word_count" value="600">
                            <p class="description">OpenAI GPT-4 output limit. Pro version with Anthropic Claude supports 2500+ words.</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label>Cluster Word Count</label>
                        </th>
                        <td>
                            <div style="background: #f0f7ff; padding: 12px 15px; border-radius: 6px; border-left: 4px solid #0073aa;">
                                <strong>~600 words</strong> - OpenAI Free Limit
                            </div>
                            <input type="hidden" name="aiab_cluster_word_count" value="600">
                            <p class="description">OpenAI GPT-4 output limit. Pro version with Anthropic Claude supports 1500+ words.</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label>Spheres per Day</label>
                        </th>
                        <td>
                            <div style="background: #fff3cd; padding: 12px 15px; border-radius: 6px; border-left: 4px solid #ffc107;">
                                <strong>1 thought sphere per day</strong> - Free Version Limit
                            </div>
                            <p class="description">
                                Creates 4 articles daily. <a href="https://eternalautoblogger.com" target="_blank">Upgrade to Pro</a> for unlimited spheres.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_max_tokens">Max Output Tokens</label>
                        </th>
                        <td>
                            <select id="aiab_max_tokens" name="aiab_max_tokens">
                                <?php $current_tokens = get_option('aiab_max_tokens', 4096); ?>
                                <option value="2048" <?php selected($current_tokens, 2048); ?>>2048 (~400 words) - Budget</option>
                                <option value="4096" <?php selected($current_tokens, 4096); ?>>4096 (~600 words) - Standard ⭐</option>
                            </select>
                            <p class="description">OpenAI max is 4096 tokens. Higher values available with Anthropic Claude in Pro version.</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_budget_mode">💰 Budget Mode</label>
                        </th>
                        <td>
                            <label>
                                <input type="checkbox" id="aiab_budget_mode" name="aiab_budget_mode" value="1" 
                                       <?php checked(get_option('aiab_budget_mode', 0), 1); ?>>
                                Enable Budget Mode (reduce token usage by ~40%)
                            </label>
                            <p class="description">
                                Skips AI verification steps and uses shorter prompts. Saves ~5,000-8,000 tokens per sphere.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_skip_research_ai">Skip AI Research</label>
                        </th>
                        <td>
                            <label>
                                <input type="checkbox" id="aiab_skip_research_ai" name="aiab_skip_research_ai" value="1" 
                                       <?php checked(get_option('aiab_skip_research_ai', 0), 1); ?>>
                                Use only search-based topic discovery (no AI)
                            </label>
                            <p class="description">
                                Saves ~2,600 tokens per sphere but may result in less persona-aligned topics.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_external_link_sources">External Link Sources</label>
                        </th>
                        <td>
                            <textarea id="aiab_external_link_sources" name="aiab_external_link_sources" 
                                      rows="3" class="large-text"><?php echo esc_textarea(get_option('aiab_external_link_sources', '')); ?></textarea>
                            <p class="description">One URL per line. Randomly added as external references in articles.</p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Publishing Settings -->
            <div class="aiab-card">
                <h2>📤 Publishing Settings</h2>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="aiab_post_status">Default Post Status</label>
                        </th>
                        <td>
                            <select id="aiab_post_status" name="aiab_post_status">
                                <option value="publish" <?php selected(get_option('aiab_post_status', 'publish'), 'publish'); ?>>Published</option>
                                <option value="draft" <?php selected(get_option('aiab_post_status'), 'draft'); ?>>Draft (Review First)</option>
                                <option value="pending" <?php selected(get_option('aiab_post_status'), 'pending'); ?>>Pending Review</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_default_category">Default Category</label>
                        </th>
                        <td>
                            <select id="aiab_default_category" name="aiab_default_category">
                                <?php foreach ($categories as $category): ?>
                                    <option value="<?php echo esc_attr($category->term_id); ?>" 
                                            <?php selected(get_option('aiab_default_category', 1), $category->term_id); ?>>
                                        <?php echo esc_html($category->name); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_author_id">Post Author</label>
                        </th>
                        <td>
                            <select id="aiab_author_id" name="aiab_author_id">
                                <?php foreach ($users as $user): ?>
                                    <option value="<?php echo esc_attr($user->ID); ?>"
                                            <?php selected(get_option('aiab_author_id', 1), $user->ID); ?>>
                                        <?php echo esc_html($user->display_name); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Schedule Settings -->
            <div class="aiab-card">
                <h2>⏰ Schedule Settings</h2>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="aiab_cron_schedule">Run Frequency</label>
                        </th>
                        <td>
                            <select id="aiab_cron_schedule" name="aiab_cron_schedule">
                                <option value="hourly" <?php selected(get_option('aiab_cron_schedule', 'daily'), 'hourly'); ?>>Hourly</option>
                                <option value="every_six_hours" <?php selected(get_option('aiab_cron_schedule'), 'every_six_hours'); ?>>Every 6 Hours</option>
                                <option value="twice_daily" <?php selected(get_option('aiab_cron_schedule'), 'twice_daily'); ?>>Twice Daily</option>
                                <option value="daily" <?php selected(get_option('aiab_cron_schedule'), 'daily'); ?>>Daily</option>
                                <option value="weekly" <?php selected(get_option('aiab_cron_schedule'), 'weekly'); ?>>Weekly</option>
                            </select>
                            <p class="description">How often to run the autoblogger cycle</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_timezone">Timezone</label>
                        </th>
                        <td>
                            <?php 
                            $current_tz = get_option('aiab_timezone', 'UTC');
                            $regions = array(
                                'Africa' => DateTimeZone::AFRICA,
                                'America' => DateTimeZone::AMERICA,
                                'Asia' => DateTimeZone::ASIA,
                                'Atlantic' => DateTimeZone::ATLANTIC,
                                'Australia' => DateTimeZone::AUSTRALIA,
                                'Europe' => DateTimeZone::EUROPE,
                                'Indian' => DateTimeZone::INDIAN,
                                'Pacific' => DateTimeZone::PACIFIC
                            );
                            ?>
                            <select id="aiab_timezone" name="aiab_timezone">
                                <option value="UTC" <?php selected($current_tz, 'UTC'); ?>>UTC (Server Default)</option>
                                <?php foreach ($regions as $region_name => $region_const): ?>
                                    <optgroup label="<?php echo esc_attr($region_name); ?>">
                                        <?php 
                                        $timezones = DateTimeZone::listIdentifiers($region_const);
                                        foreach ($timezones as $tz): 
                                            $display_name = str_replace('_', ' ', str_replace($region_name . '/', '', $tz));
                                        ?>
                                            <option value="<?php echo esc_attr($tz); ?>" <?php selected($current_tz, $tz); ?>>
                                                <?php echo esc_html($display_name); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endforeach; ?>
                            </select>
                            <p class="description">Times in dashboard and logs will display in this timezone</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="aiab_max_execution_time">Max Execution Time</label>
                        </th>
                        <td>
                            <input type="number" id="aiab_max_execution_time" name="aiab_max_execution_time" 
                                   min="60" max="600" value="<?php echo esc_attr(get_option('aiab_max_execution_time', 300)); ?>">
                            <span class="description">seconds</span>
                            <p class="description">Maximum time for each cycle. Work will continue in the next cycle if needed.</p>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <?php submit_button('💾 Save Settings', 'primary', 'submit', true, array('id' => 'aiab-save-settings')); ?>
    </form>
    
    <!-- Pro Version Upsell with Image -->
    <div class="aiab-card" style="margin-top: 30px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; overflow: hidden;">
        <div style="display: flex; flex-wrap: wrap; gap: 30px; align-items: center;">
            <div style="flex: 1; min-width: 300px;">
                <h2 style="color: white; margin-top: 0; font-size: 28px;">⭐ Upgrade to Eternal Auto Blogger Pro</h2>
                <p style="font-size: 16px; opacity: 0.95;">Unlock the full power of automated content creation:</p>
                <ul style="list-style: none; padding: 0; margin: 20px 0;">
                    <li style="padding: 8px 0;">✅ <strong>Unlimited Thought Spheres</strong> - No daily limits</li>
                    <li style="padding: 8px 0;">✅ <strong>Up to 10 Articles per Sphere</strong> - Build massive topic clusters</li>
                    <li style="padding: 8px 0;">✅ <strong>2500+ Word Articles</strong> - With Anthropic Claude AI</li>
                    <li style="padding: 8px 0;">✅ <strong>Multiple AI Providers</strong> - OpenAI, Anthropic, Perplexity</li>
                    <li style="padding: 8px 0;">✅ <strong>Premium Search APIs</strong> - Google CSE, SerpAPI, ValueSERP</li>
                    <li style="padding: 8px 0;">✅ <strong>Stability AI Images</strong> - Alternative to DALL-E</li>
                    <li style="padding: 8px 0;">✅ <strong>Priority Support</strong> - Get help when you need it</li>
                </ul>
                <p style="margin-top: 25px;">
                    <a href="https://eternalautoblogger.com" target="_blank" class="button button-primary" style="background: white; color: #667eea; border: none; font-weight: bold; padding: 12px 30px; font-size: 16px; border-radius: 6px; text-decoration: none;">
                        🚀 Get Pro Version - $99/month
                    </a>
                </p>
            </div>
            <div style="flex: 1; min-width: 280px; text-align: center;">
                <div style="background: white; border-radius: 12px; padding: 20px; box-shadow: 0 10px 40px rgba(0,0,0,0.2);">
                    <p style="color: #333; font-weight: bold; margin: 0 0 15px 0;">🎯 Topic Cluster Diagram</p>
                    <svg viewBox="0 0 300 300" style="max-width: 260px; height: auto;">
                        <!-- Center pillar -->
                        <circle cx="150" cy="150" r="45" fill="#667eea" stroke="#5a67d8" stroke-width="3"/>
                        <text x="150" y="145" text-anchor="middle" fill="white" font-size="10" font-weight="bold">Pillar</text>
                        <text x="150" y="160" text-anchor="middle" fill="white" font-size="9">Article</text>
                        
                        <!-- Cluster articles -->
                        <circle cx="150" cy="50" r="32" fill="white" stroke="#48bb78" stroke-width="3"/>
                        <text x="150" y="53" text-anchor="middle" fill="#333" font-size="9">Cluster 1</text>
                        
                        <circle cx="237" cy="100" r="32" fill="white" stroke="#48bb78" stroke-width="3"/>
                        <text x="237" y="103" text-anchor="middle" fill="#333" font-size="9">Cluster 2</text>
                        
                        <circle cx="237" cy="200" r="32" fill="white" stroke="#48bb78" stroke-width="3"/>
                        <text x="237" y="203" text-anchor="middle" fill="#333" font-size="9">Cluster 3</text>
                        
                        <circle cx="150" cy="250" r="32" fill="white" stroke="#48bb78" stroke-width="3"/>
                        <text x="150" y="253" text-anchor="middle" fill="#333" font-size="9">Cluster 4</text>
                        
                        <circle cx="63" cy="200" r="32" fill="white" stroke="#48bb78" stroke-width="3"/>
                        <text x="63" y="203" text-anchor="middle" fill="#333" font-size="9">Cluster 5</text>
                        
                        <circle cx="63" cy="100" r="32" fill="white" stroke="#48bb78" stroke-width="3"/>
                        <text x="63" y="103" text-anchor="middle" fill="#333" font-size="9">Cluster 6</text>
                        
                        <!-- Hub links (from center to clusters) -->
                        <line x1="150" y1="105" x2="150" y2="82" stroke="#48bb78" stroke-width="2"/>
                        <line x1="190" y1="120" x2="210" y2="115" stroke="#48bb78" stroke-width="2"/>
                        <line x1="190" y1="180" x2="210" y2="185" stroke="#48bb78" stroke-width="2"/>
                        <line x1="150" y1="195" x2="150" y2="218" stroke="#48bb78" stroke-width="2"/>
                        <line x1="110" y1="180" x2="90" y2="185" stroke="#48bb78" stroke-width="2"/>
                        <line x1="110" y1="120" x2="90" y2="115" stroke="#48bb78" stroke-width="2"/>
                        
                        <!-- Circular links between clusters -->
                        <path d="M 175 55 Q 200 30 225 75" fill="none" stroke="#9ae6b4" stroke-width="2" stroke-dasharray="4"/>
                        <path d="M 260 130 Q 280 165 260 195" fill="none" stroke="#9ae6b4" stroke-width="2" stroke-dasharray="4"/>
                        <path d="M 225 225 Q 200 265 175 245" fill="none" stroke="#9ae6b4" stroke-width="2" stroke-dasharray="4"/>
                        <path d="M 125 245 Q 100 265 75 225" fill="none" stroke="#9ae6b4" stroke-width="2" stroke-dasharray="4"/>
                        <path d="M 40 195 Q 20 165 40 130" fill="none" stroke="#9ae6b4" stroke-width="2" stroke-dasharray="4"/>
                        <path d="M 75 75 Q 100 30 125 55" fill="none" stroke="#9ae6b4" stroke-width="2" stroke-dasharray="4"/>
                    </svg>
                    <p style="color: #666; font-size: 12px; margin: 10px 0 0 0;">Pro supports up to 10 interlinked articles per sphere!</p>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Support Section -->
    <div class="aiab-card" style="margin-top: 20px; background: #f8f9fa; border: 1px solid #e9ecef;">
        <h2 style="margin-top: 0;">💬 Need Help?</h2>
        <p>We're here to help you get the most out of Eternal Auto Blogger!</p>
        <div style="display: flex; flex-wrap: wrap; gap: 20px; margin-top: 15px;">
            <a href="https://eternalautoblogger.com/#contact" target="_blank" class="button button-secondary" style="display: inline-flex; align-items: center; gap: 8px; padding: 10px 20px;">
                📝 Contact Form
            </a>
            <a href="mailto:help@eternalautoblogger.com" class="button button-secondary" style="display: inline-flex; align-items: center; gap: 8px; padding: 10px 20px;">
                ✉️ help@eternalautoblogger.com
            </a>
            <a href="https://eternalautoblogger.com/docs" target="_blank" class="button button-secondary" style="display: inline-flex; align-items: center; gap: 8px; padding: 10px 20px;">
                📚 Documentation
            </a>
        </div>
    </div>
</div>

<style>
.aiab-required {
    color: #d63638;
    font-weight: bold;
    font-size: 11px;
}
</style>

