<?php
/**
 * Eternal Auto Blogger Uninstall
 * 
 * This file runs when the plugin is deleted (not just deactivated).
 * By default, we PRESERVE all data to prevent accidental loss.
 */

// Exit if not called by WordPress
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Check if user wants to delete data on uninstall
$delete_data = get_option('aiab_delete_data_on_uninstall', false);

if (!$delete_data) {
    // PRESERVE DATA - Do nothing, keep all tables and options
    // User can reinstall and their personas/spheres will still be there
    return;
}

// If delete_data is enabled, remove everything
global $wpdb;

// Drop custom tables
$tables = array(
    'aiab_personas',
    'aiab_thought_spheres', 
    'aiab_articles',
    'aiab_topic_history',
    'aiab_research_cache',
    'aiab_log',
    'aiab_queue'
);

foreach ($tables as $table) {
    $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}{$table}");
}

// Delete options
$options = array(
    'aiab_db_version',
    'aiab_cron_schedule',
    'aiab_articles_per_sphere',
    'aiab_ai_provider',
    'aiab_ai_model',
    'aiab_image_provider',
    'aiab_image_style',
    'aiab_auto_publish',
    'aiab_post_status',
    'aiab_external_link_sources',
    'aiab_pillar_word_count',
    'aiab_cluster_word_count',
    'aiab_max_tokens',
    'aiab_anthropic_api_key',
    'aiab_openai_api_key',
    'aiab_serpapi_key',
    'aiab_stability_api_key',
    'aiab_default_category',
    'aiab_author_id',
    'aiab_max_execution_time',
    'aiab_debug_mode',
    'aiab_error_notifications',
    'aiab_error_notification_email',
    'aiab_log_retention_days',
    'aiab_delete_data_on_uninstall'
);

foreach ($options as $option) {
    delete_option($option);
}

// Clear scheduled cron
wp_clear_scheduled_hook('aiab_run_autoblogger');
